//
//  TexureLoader.h
//  Engine
//
//  Created by ss2cire on 10/13/08.
//  Copyright 2008 GryphonClaw Software. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <OpenGL/gl.h>

@interface TextureManager : NSObject
{
	NSMutableDictionary *textures;
}

+ (TextureManager *)sharedManager;

- (GLuint)textureWithName:(NSString *)name;

//This method really shouldn't be called directly, as it doesn't
//check to see if the file specified at path exists.
//It should only be called from textureWithName: which actually
//does check to see if the file exists first.
- (GLuint)loadImageFromPath:(NSString *)path;
@end
